import sys
input = sys.stdin.readline

N, Q = map(int, input().split())
a = list(map(int, input().split()))

from collections import Counter

def min_sum(k):
    hand_count = Counter()
    for i in range(k):
        hand_count[a[i]] += 1
    
    freq_total = Counter(a[k:])
    
    for num in freq_total:
        if num in hand_count:
            hand_count[num] -= freq_total[num]
            if hand_count[num] < 0:
                hand_count[num] = 0
    
    s = sum(num * count for num, count in hand_count.items())
    return s

for _ in range(Q):
    query = input().split()
    t = int(query[0])
    if t == 1:
        k = int(query[1])
        print(min_sum(k))
    else:
        x, y = int(query[1]), int(query[2])
        a[x-1] = y